// Isolated Point Weld.js
//
// 2012-10-04: firset release
//
// Hiroto Tsubaki tg@tres-graficos.jp
//

function buildUI( tool ) {
  tool.addParameterSeparator("Isolated Point Weld");
  
  tool.addParameterBool("only selection", 0, 0, 1, false, false );
  tool.addParameterFloat("maximum distance", 0.05, 0, 100, false, false );
  tool.addParameterSelector("weld to", ["isolated point", "middle"], false );
  tool.addParameterBool("delete after weld", 1, 0, 1, false, false);
  
  tool.addParameterButton("weld", "apply", "smartWeld");
}

function smartWeld( tool ) {
  var doc = tool.document();
  var obj = doc.selectedObject();
  
  if (!obj) {
    OS.beep(); return;
  }
  
  var maxDistance = tool.getParameter("maximum distance");
  var onlySelection = tool.getParameter("only selection");
  var weldTo = tool.getParameter("weld to");
  var del = tool.getParameter("delete after weld");
  
  print( '----' );
  if (obj.type() == POLYGONOBJ) {
    var i, j;
    
    var core = obj.core();
    
    var vertices = new Array();
    var vertexCount = core.vertexCount();
    for (i = 0;i < vertexCount;i++) {
      vertices[i] = [ core.vertex(i), 0 ]; // vector, refCount
    }
    
    var polygonCount = core.polygonCount();
    for (i = 0;i < polygonCount;i++) {
      var polygonSize = core.polygonSize( i );
      for (j = 0;j < polygonSize;j++) {
        var vertexIndex = core.vertexIndex( i, j );
        vertices[ vertexIndex ][ 1 ]++;
      }
    }
    
    // for undo/redo
    if (tool.parameterWithName) obj.recordGeometryForUndo();
    
    var dels = [];
    
    for (i = 0;i < vertexCount;i++) {
      
      if (onlySelection && !core.vertexSelection( i ) ) continue; 
      
      if (vertices[ i ][1] == 0) { // isolated point
        var vertexIndices = [];
        
        for (j = 0;j < vertexCount;j++) {
          
          if (onlySelection && !core.vertexSelection( j ) ) continue;
          
          if (vertices[j][1] > 0) {
            var cmpDist = Vec3D_distance( vertices[i][0], vertices[j][0] );
            
            if (maxDistance > cmpDist) {
              vertexIndices.push( [j, cmpDist] );
            }
          }
        }
        
        if (vertexIndices.length > 0) {
          //print( i + ':' + vertexIndices );
          
          var indexMin = vertexIndices[0][0];
          var min = vertexIndices[0][1];
          var confused = false;
          for (var j = 1;j < vertexIndices.length;j++) {
            if (min > vertexIndices[j][1]) {
              indexMin = vertexIndices[j][0];
              min = vertexIndices[j][1];
              if (min > vertexIndices[j][1] + maxDistance / 10) { // for safety
                confused = true;
              }
            }
          }
          //print( indexMin.toFixed(3) + ':' + min.toFixed(3) );
          if (!confused) {
            if (weldTo == 0) {
              core.setVertex( indexMin, vertices[i][0] );
            } else {
              core.setVertex( indexMin, vertices[i][0].add( vertices[ indexMin ][0] ).multiply( 0.5 ) );
            }
            dels.push( i );
          }
        }
      }
    }
    
    if (del) {
      dels.sort();
      for (i = dels.length-1;i >= 0;i--) {
        core.deleteVertex( dels[i] );
      }
    }
    
    obj.update();
  }
}
var Vec3D_distance = function() {
  if( arguments.length == 1)
      return Math.sqrt( arguments[0].x*arguments[0].x + arguments[0].y*arguments[0].y + arguments[0].z*arguments[0].z );
  var p = arguments[1].sub(arguments[0]);
  return Math.sqrt( p.x*p.x + p.y*p.y + p.z*p.z );
}

var Vec3D_normalize = function(vec) {
  var l = vec.norm();
  if (l != 0) {
    return vec.multiply( 1/l );
  }
  return vec;
}

Array.prototype.toString = function() {
	var len = this.length;
	var str = '[';
	for (var i =0;i < len;i++) {
		str += this[i]
		if (i != len-1) str += ', ';
	}
	return str + ']';
}

